

package w83a.w83aUtilidadesComunes;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

import w83a.xml.W83AXmlElement;
import w83a.xml.W83AXmlElements;
import w83a.xml.exception.W83AXmlException;



public class W83ALocaleStringXML implements java.io.Serializable{//NOPMD
    /**
	 * Comment for <code>serialVersionUID</code>
	 */
	private static final long serialVersionUID = 1L;
	private static final String _LOCALE_END = "\">";
    private static final String _LOCALE_INI = " locale=\"";
    private static final String LOCALE = "locale";
    private static final String _NADA = "";
    private static final String __END_TAG = "</";
    private static final String _END_TAG = ">";
    private static final String _INI_TAG = "<";
    private static final String DEF_TAG = "description";
    private static final String LANGUAGE = "language";
    private static final String XML_FRAGMENT = "xml-fragment";
    
    public static final String ES_STR = "es";
    public static final String EU_STR = "eu";
    public static final Locale ES = new Locale (ES_STR);
    public static final Locale EU = new Locale (EU_STR);
    public static final String iniCdata = "<![CDATA[";
	public static final String finCdata = "]]>";
    
    public static synchronized W83ALocaleString getLocaleString(String str) {
        if (str == null){
            return null;
        }
        return new W83ALazyLocaleString (str);
    }

    public static W83ALocaleString getLocaleString(W83AXmlElement element) {
        //Si no hay informacion de entrada, entonces tampoco de salida
        if (element == null){
            return null;
        }

        Hashtable descs = new Hashtable();

        W83AXmlElements elements = element.getChildElements();
        for (int counter = 1; counter <= elements.getCount(); counter++) {
            String idioma = elements.getItem(counter).getDomElement().getAttribute(LOCALE);
            descs.put(getLocale(idioma), elements.getItem(counter).getValue());
        }

        return new W83ALocaleString(descs);
    }

    public static String toXml(W83ALocaleString str) {
        return toXml(str, DEF_TAG);
    }
    public static String toXmlNoCDATA(W83ALocaleString str) {
        return toXmlNoCDATA(str, DEF_TAG);
    }
    public static String toXmlFragment(W83ALocaleString str) {
        StringBuffer sb = new StringBuffer();
        sb.append(_INI_TAG).append (XML_FRAGMENT).append(_END_TAG);
        sb.append (toCDATAXml(str, DEF_TAG));
        sb.append(__END_TAG).append (XML_FRAGMENT).append(_END_TAG);
    	return sb.toString();
    }

    public static String toXml(W83ALocaleString str, String tag) {
    	return toCDATAXml(str, tag);
    }
    public static String toXmlFragment(W83ALocaleString str, String tag) {
        StringBuffer sb = new StringBuffer();
        sb.append(_INI_TAG).append (XML_FRAGMENT).append(_END_TAG);
        sb.append (toCDATAXml(str, tag));
        sb.append(__END_TAG).append (XML_FRAGMENT).append(_END_TAG);
    	return sb.toString();
    }
    public static String toXmlNoCDATA(W83ALocaleString str, String tag) {
        if (str == null){
            return _NADA;
        }
        StringBuffer rdo = new StringBuffer();
        rdo.append(_INI_TAG).append(tag).append(_END_TAG);

        Enumeration e = str.getAllLocales();
        while (e.hasMoreElements()) {
            Locale l = (Locale) e.nextElement();
            rdo.append(_INI_TAG).append(LANGUAGE).append(_LOCALE_INI).append(l.toString()).append(_LOCALE_END);
            rdo.append(str.getString(l));
            rdo.append(__END_TAG).append(LANGUAGE).append(_END_TAG);
        }
        rdo.append(__END_TAG).append(tag).append(_END_TAG);
        
        return rdo.toString();
    }

    public static String toXmlNoCDATAFragment(W83ALocaleString str, String tag) {
        if (str == null){
            return _NADA;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(_INI_TAG).append (XML_FRAGMENT).append(_END_TAG);
        sb.append (toXmlNoCDATA(str, tag));
        sb.append(__END_TAG).append (XML_FRAGMENT).append(_END_TAG);
    	return sb.toString();
    }

    public static String toCDATAXml(W83ALocaleString str, String tag) {
        if (str == null){
            return _NADA;
        }
        StringBuffer rdo = new StringBuffer();
        rdo.append(_INI_TAG).append(tag).append(_END_TAG);

        Enumeration e = str.getAllLocales();
        while (e.hasMoreElements()) {
            Locale l = (Locale) e.nextElement();
            rdo.append(_INI_TAG).append(LANGUAGE).append(_LOCALE_INI).append(l.toString()).append(_LOCALE_END);
            rdo.append(iniCdata).append(str.getString(l)).append(finCdata);
            rdo.append(__END_TAG).append(LANGUAGE).append(_END_TAG);
        }
        rdo.append(__END_TAG).append(tag).append(_END_TAG);

        return rdo.toString();
    }

    public static Element toXmlElementNoCDATA(W83ALocaleString str, Document ownerDocument) 
    throws W83AXmlException {
    	return toXmlElementNoCDATA(str, DEF_TAG, ownerDocument);
    }

    public static Element toXmlElementNoCDATA(W83ALocaleString str, String tag, Document ownerDocument) 
    throws W83AXmlException {
		Element rootElement = ownerDocument.createElement(tag);
        Enumeration e = str.getAllLocales();
        while (e.hasMoreElements()) {
			Element languageElement = ownerDocument.createElement(LANGUAGE);
            Locale l = (Locale) e.nextElement();
			Text localeText = ownerDocument.createTextNode(str.getString(l));
			languageElement.appendChild(localeText);
			languageElement.setAttribute("locale", l.getLanguage());
			rootElement.appendChild(languageElement);
        }

		return rootElement;
    }
    
    public static Locale getLocale(String language) {
        return (language.equals(ES_STR))
    					? ES
    					: EU;
    }    
}